/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.tileentities.redstone;

import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import com.Da_Technomancer.essentials.tileentities.LinkHelper;
import com.Da_Technomancer.essentials.tileentities.redstone.RedstoneReceiverTileEntity;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

@ObjectHolder(value="essentials")
public class RedstoneTransmitterTileEntity
extends BlockEntity
implements ILinkTE {
    @ObjectHolder(value="redstone_transmitter")
    public static BlockEntityType<RedstoneTransmitterTileEntity> TYPE = null;
    public final LinkHelper linkHelper = new LinkHelper(this);
    private boolean builtConnections = false;
    private float output;
    private final LazyOptional<IRedstoneHandler> circOpt = LazyOptional.of(() -> new CircuitHandler());
    private WeakReference<LazyOptional<IRedstoneHandler>> circRef = new WeakReference<LazyOptional<IRedstoneHandler>>(this.circOpt);
    private final ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>> sources = new ArrayList(1);

    public RedstoneTransmitterTileEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    public AABB getRenderBoundingBox() {
        return this.linkHelper.frustrum();
    }

    @Override
    public boolean canBeginLinking() {
        return true;
    }

    public void dye(DyeColor color) {
        if (this.m_58900_().m_61143_(ESProperties.COLOR) != color) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_(ESProperties.COLOR, (Comparable)color));
            for (BlockPos link : this.linkHelper.getLinksAbsolute()) {
                BlockState linkState = this.f_58857_.m_8055_(link);
                if (linkState.m_60734_() != ESBlocks.redstoneReceiver) continue;
                this.f_58857_.m_46597_(link, (BlockState)linkState.m_61124_(ESProperties.COLOR, (Comparable)color));
            }
        }
    }

    public float getOutput() {
        if (!this.builtConnections) {
            this.buildConnections();
        }
        return this.output;
    }

    @Override
    public void removeLinkSource(BlockPos end) {
        this.linkHelper.removeLink(end);
    }

    public void buildConnections() {
        if (!this.f_58857_.f_46443_) {
            this.builtConnections = true;
            ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>> preSrc = new ArrayList<Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>>(this.sources.size());
            preSrc.addAll(this.sources);
            this.sources.clear();
            for (Direction checkDir : Direction.values()) {
                IRedstoneHandler otherHandler;
                BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(checkDir));
                if (te == null || (otherHandler = (IRedstoneHandler)BlockUtil.get(te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, checkDir.m_122424_()))) == null) continue;
                otherHandler.requestSrc(this.circRef, 0, checkDir.m_122424_(), checkDir);
            }
            if (this.sources.size() != preSrc.size() || !this.sources.containsAll(preSrc)) {
                this.f_58857_.m_186464_(this.f_58858_, (Block)ESBlocks.redstoneTransmitter, 2, TickPriority.NORMAL);
            }
        }
    }

    public void refreshOutput() {
        if (!this.builtConnections) {
            this.buildConnections();
        }
        float input = 0.0f;
        Direction[] sidesToCheck = Direction.values();
        for (int i = 0; i < this.sources.size(); ++i) {
            IRedstoneHandler handl;
            Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction> ref = this.sources.get(i);
            if (ref == null || (handl = (IRedstoneHandler)BlockUtil.get((LazyOptional)((WeakReference)ref.getLeft()).get())) == null) {
                this.sources.remove(i);
                --i;
                continue;
            }
            sidesToCheck[((Direction)ref.getRight()).m_122411_()] = null;
            input = RedstoneUtil.chooseInput(input, RedstoneUtil.sanitize(handl.getOutput()));
        }
        for (Direction dir : sidesToCheck) {
            if (dir == null) continue;
            input = RedstoneUtil.chooseInput(input, RedstoneUtil.getRedstoneOnSide(this.f_58857_, this.f_58858_, dir));
        }
        if (RedstoneUtil.didChange(this.output, input = RedstoneUtil.sanitize(input))) {
            this.output = input;
            for (BlockPos link : this.linkHelper.getLinksAbsolute()) {
                BlockEntity te = this.f_58857_.m_7702_(link);
                if (!(te instanceof RedstoneReceiverTileEntity)) continue;
                ((RedstoneReceiverTileEntity)te).notifyOutputChange();
            }
            this.m_6596_();
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.linkHelper.writeNBT(nbt);
        return nbt;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.output = nbt.m_128457_("out");
        this.linkHelper.readNBT(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_("out", this.output);
        this.linkHelper.writeNBT(nbt);
    }

    @Override
    public BlockEntity getTE() {
        return this;
    }

    @Override
    public Color getColor() {
        return new Color(((DyeColor)this.m_58900_().m_61143_(ESProperties.COLOR)).m_41071_());
    }

    @Override
    public boolean canLink(ILinkTE otherTE) {
        return otherTE instanceof RedstoneReceiverTileEntity;
    }

    @Override
    public Set<BlockPos> getLinks() {
        return this.linkHelper.getLinksRelative();
    }

    @Override
    public int getRange() {
        return (Integer)ESConfig.wirelessRange.get();
    }

    @Override
    public int getMaxLinks() {
        return 64;
    }

    @Override
    public boolean createLinkSource(ILinkTE endpoint, @Nullable Player player) {
        return this.linkHelper.addLink(endpoint, player);
    }

    @Override
    public void receiveLong(byte identifier, long message, @Nullable ServerPlayer sendingPlayer) {
        this.linkHelper.handleIncomingPacket(identifier, message);
    }

    public void m_7651_() {
        super.m_7651_();
        this.circOpt.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            return this.circOpt;
        }
        return super.getCapability(cap, side);
    }

    private class CircuitHandler
    implements IRedstoneHandler {
        private CircuitHandler() {
        }

        @Override
        public float getOutput() {
            return 0.0f;
        }

        @Override
        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> src, int dist, Direction fromSide, Direction nominalSide) {
            LazyOptional srcOption = (LazyOptional)src.get();
            if (srcOption != null && srcOption.isPresent()) {
                IRedstoneHandler srcHandler = (IRedstoneHandler)BlockUtil.get(srcOption);
                srcHandler.addDependent(RedstoneTransmitterTileEntity.this.circRef, nominalSide);
                Pair srcPair = Pair.of(src, (Object)fromSide);
                if (!RedstoneTransmitterTileEntity.this.sources.contains(srcPair)) {
                    RedstoneTransmitterTileEntity.this.sources.add((Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>)srcPair);
                }
            }
        }

        @Override
        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> dependency, int dist, Direction toSide, Direction nominalSide) {
        }

        @Override
        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> src, Direction fromSide) {
            Pair srcPair = Pair.of(src, (Object)fromSide);
            if (!RedstoneTransmitterTileEntity.this.sources.contains(srcPair)) {
                RedstoneTransmitterTileEntity.this.sources.add((Pair<WeakReference<LazyOptional<IRedstoneHandler>>, Direction>)srcPair);
                this.notifyInputChange(src);
            }
        }

        @Override
        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> dependent, Direction toSide) {
        }

        @Override
        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> src) {
            RedstoneTransmitterTileEntity.this.f_58857_.m_186464_(RedstoneTransmitterTileEntity.this.f_58858_, (Block)ESBlocks.redstoneTransmitter, 2, TickPriority.HIGH);
        }
    }
}

